<?php

/**
 * Min Max & Step panel for each Product's edit page
 * Field adding to Product Page
 * 
 * @since 1.0
 * @link https://docs.woocommerce.com/wc-apidocs/source-function-woocommerce_wp_text_input.html#14-79 Details of woocommerce_wp_text_input() from WooCommerce
 */
function wcmmq_add_field_in_panel(){
    $current_lang = apply_filters( 'wpml_current_language', NULL );
    $lang = apply_filters('wpml_default_language', NULL );
    if(!empty($current_lang) && !empty($lang) && $current_lang != $lang){
        $message = __( 'You have to input Min max and step value in your default language product.', 'woo-min-max-quantity-step-control-single' );
        if( function_exists( 'woocommerce_wp_note' ) ){
            woocommerce_wp_note([
                'id'    => 'wcmmq_note_for_wpml',
                'class' => 'wcmmq_note_for_wpml',
                'message' => $message,
                'type'  =>  'warning',
                'label'     =>  __( 'Important:', 'woo-min-max-quantity-step-control-single' ),
        
            ]);
        }
        return;
    }

    $is_pro = defined('WC_MMQ_PRO_VERSION');
    $data_type = 'decimal';
    $tip_color = 'wcmmq-tips-note';
    $message = "If you want to input Decimal value for minimum, maxium and step, Need pro version.";
    if($is_pro){
        $tip_color = 'wcmmq-tips-note-pro';
        $message = "You able to add decimal value as your min max and step.";
    }
    $args = array();
    $args[] = array(
        'id'        =>  WC_MMQ_PREFIX. 'min_quantity',
        'name'        =>  WC_MMQ_PREFIX. 'min_quantity',
        'label'     =>  __( 'Minimum Quantity', 'woo-min-max-quantity-step-control-single' ),
        'class'     =>  'wcmmq_input',
        'type'      =>  'text',
        'desc_tip'  =>  true,
        'description'=> __( 'Enter Minimum Quantity for this Product', 'woo-min-max-quantity-step-control-single' ),
        'data_type' => $data_type
    );
    $default_qty = apply_filters( 'wcmmq_default_qty_option', false, get_the_ID() );
    if( $default_qty ){
        $args[] = array(
            'id'        =>  WC_MMQ_PREFIX. 'default_quantity',
            'name'        =>  WC_MMQ_PREFIX. 'default_quantity',
            'label'     =>  __( 'Default Quantity (Optional)', 'woo-min-max-quantity-step-control-single' ),
            'class'     =>  'wcmmq_input',
            'type'      =>  'text',
            'desc_tip'  =>  true,
            'description'=> __( 'It is an optional Number, If do not set, Product default quantity will come from Minimum Quantity', 'woo-min-max-quantity-step-control-single' ),
            'data_type' => $data_type
        );
    }    
    $args[] = array(
        'id'        =>  WC_MMQ_PREFIX. 'max_quantity',
        'name'        =>  WC_MMQ_PREFIX. 'max_quantity',
        'label'     =>  __( 'Maximum Quantity', 'woo-min-max-quantity-step-control-single' ),
        'class'     =>  'wcmmq_input',
        'type'      =>  'text',
        'desc_tip'  =>  true,
        'description'=> __( 'Enter Maximum Quantity for this Product', 'woo-min-max-quantity-step-control-single' ),
        'data_type' => $data_type
    );
    
    
    
    $args[] = array(
        'id'        =>  WC_MMQ_PREFIX. 'product_step',
        'name'        =>  WC_MMQ_PREFIX. 'product_step',
        'label'     =>  __( 'Quantity Step', 'woo-min-max-quantity-step-control-single' ),
        'class'     =>  'wcmmq_input',
        'type'      =>  'text',
        'desc_tip'  =>  true,
        'description'=> __( 'Enter quantity Step', 'woo-min-max-quantity-step-control-single' ),
        'data_type' => $data_type
    );

    $args = apply_filters('wcmmq_field_args_in_panel', $args);

    foreach($args as $arg){
        woocommerce_wp_text_input($arg);
    }
    woocommerce_wp_hidden_input([
        'id'        =>  'wcmmq_nonce',
        'name'        =>  'wcmmq_nonce',
        'value'     =>  wp_create_nonce( WC_MMQ_PLUGIN_BASE_FOLDER ),
    ]);
    if( function_exists( 'woocommerce_wp_note' ) ){
        woocommerce_wp_note([
            'id'    => $tip_color,
            'class' => $tip_color,
            'message' => $message,
            'label'     =>  __( 'Important:', 'woo-min-max-quantity-step-control-single' ),
    
        ]);
    }
    
}

add_action('woocommerce_product_options_wcmmq_minmaxstep','wcmmq_add_field_in_panel'); //Our custom action, which we have created to product_panel.php file


/**
 * To save and update our Data.
 * We have fixed , if anybody mismathch with min and max. Than max will be automatically increase 5 for now
 * In future we will add options, when can be change from options page
 * 
 * @param Int $post_id automatically come via woocommerce_process_product_meta as parameter.
 * return void
 */
function wcmmq_save_field_data( $post_id ){
    $nonce = sanitize_text_field( wp_unslash( $_POST['wcmmq_nonce'] ?? '' ) );
    if ( empty($nonce) && ! wp_verify_nonce( $nonce, WC_MMQ_PLUGIN_BASE_FOLDER ) ) return;
    $_min_quantity_name = WC_MMQ_PREFIX . 'min_quantity';
    $_max_quantity_name = WC_MMQ_PREFIX . 'max_quantity';
    $_product_step_name = WC_MMQ_PREFIX . 'product_step';
    $_default_quantity_name = WC_MMQ_PREFIX . 'default_quantity';

    $min_quantity = sanitize_text_field( wp_unslash( $_POST[$_min_quantity_name] ?? ''));
    $default_quantity = sanitize_text_field( wp_unslash( $_POST[$_default_quantity_name] ?? ''));
    $max_quantity = sanitize_text_field( wp_unslash( $_POST[$_max_quantity_name] ?? ''));
    $product_step = sanitize_text_field( wp_unslash( $_POST[$_product_step_name] ?? ''));
    
    $min_quantity = wc_format_decimal( $min_quantity );
    $default_quantity = wc_format_decimal( $default_quantity );
    $max_quantity = wc_format_decimal( $max_quantity );
    $product_step = wc_format_decimal( $product_step );
    
    if($min_quantity && $max_quantity && $min_quantity > $max_quantity){
        $max_quantity = $min_quantity + 5;
    }
    
    if( $max_quantity ){
        $default_quantity = $default_quantity >= $min_quantity && $default_quantity <= $max_quantity ? $default_quantity : false;
    }else{
        $default_quantity = $default_quantity >= $min_quantity ? $default_quantity : false;
    }
    
    
    //Updating Here
    update_post_meta( $post_id, $_min_quantity_name, esc_attr( $min_quantity ) ); 
    $default_qty = apply_filters( 'wcmmq_default_qty_option', false, get_the_ID() );
    if( $default_qty ){
        update_post_meta( $post_id, $_default_quantity_name, esc_attr( $default_quantity ) ); 
    }
    update_post_meta( $post_id, $_max_quantity_name, esc_attr( $max_quantity ) );
    update_post_meta( $post_id, $_product_step_name, esc_attr( $product_step ) ); 
}
add_action( 'woocommerce_process_product_meta', 'wcmmq_save_field_data' );



