<?php declare(strict_types=1);

use Automattic\WooCommerce\Internal\Fulfillments\Providers as ShippingProviders;

return array(
	'acs-courier'             => ShippingProviders\ACSCourierShippingProvider::class,
	'amazon-logistics'        => ShippingProviders\AmazonLogisticsShippingProvider::class,
	'an-post'                 => ShippingProviders\AnPostShippingProvider::class,
	'aras-kargo'              => ShippingProviders\ArasKargoShippingProvider::class,
	'australia-post'          => ShippingProviders\AustraliaPostShippingProvider::class,
	'azerpost'                => ShippingProviders\AzerpostShippingProvider::class,
	'bartolini-brt'           => ShippingProviders\BartoliniBRTShippingProvider::class,
	'belpochta'               => ShippingProviders\BelpochtaShippingProvider::class,
	'bpost'                   => ShippingProviders\BpostShippingProvider::class,
	'bulgarian-posts'         => ShippingProviders\BulgarianPostsShippingProvider::class,
	'canada-post'             => ShippingProviders\CanadaPostShippingProvider::class,
	'cdek'                    => ShippingProviders\CDEKShippingProvider::class,
	'ceska-posta'             => ShippingProviders\CeskaPostaShippingProvider::class,
	'chronopost'              => ShippingProviders\ChronopostShippingProvider::class,
	'correos'                 => ShippingProviders\CorreosShippingProvider::class,
	'ctt'                     => ShippingProviders\CTTShippingProvider::class,
	'cyprus-post'             => ShippingProviders\CyprusPostShippingProvider::class,
	'deutsche-post'           => ShippingProviders\DeutschePostShippingProvider::class,
	'dhl'                     => ShippingProviders\DHLShippingProvider::class,
	'dpd'                     => ShippingProviders\DPDShippingProvider::class,
	'econt'                   => ShippingProviders\EcontShippingProvider::class,
	'eimskip'                 => ShippingProviders\EimskipShippingProvider::class,
	'elta'                    => ShippingProviders\ELTAShippingProvider::class,
	'evri-hermes'             => ShippingProviders\EvriHermesShippingProvider::class,
	'fan-courier'             => ShippingProviders\FanCourierShippingProvider::class,
	'fastway'                 => ShippingProviders\FastwayShippingProvider::class,
	'fedex'                   => ShippingProviders\FedExShippingProvider::class,
	'geniki-taxydromiki'      => ShippingProviders\GenikiTaxydromikiShippingProvider::class,
	'gls'                     => ShippingProviders\GLSShippingProvider::class,
	'haypost'                 => ShippingProviders\HayPostShippingProvider::class,
	'helthjem'                => ShippingProviders\HelthjemShippingProvider::class,
	'hrvatska-posta'          => ShippingProviders\HrvatskaPostaShippingProvider::class,
	'inpost'                  => ShippingProviders\InPostShippingProvider::class,
	'islandspostur'           => ShippingProviders\IslandsposturShippingProvider::class,
	'itella'                  => ShippingProviders\ItellaShippingProvider::class,
	'kazpost'                 => ShippingProviders\KazpostShippingProvider::class,
	'la-poste-colissimo'      => ShippingProviders\LaPosteColissimoShippingProvider::class,
	'lasership-ontrac'        => ShippingProviders\LasershipOntracShippingProvider::class,
	'latvijas-pasts'          => ShippingProviders\LatvijasPastsShippingProvider::class,
	'liechtensteinische-post' => ShippingProviders\LiechtensteinischePostShippingProvider::class,
	'magyar-posta'            => ShippingProviders\MagyarPostaShippingProvider::class,
	'makedonska-posta'        => ShippingProviders\MakedonskaPostaShippingProvider::class,
	'maltapost'               => ShippingProviders\MaltaPostShippingProvider::class,
	'matkahuolto'             => ShippingProviders\MatkahuoltoShippingProvider::class,
	'mondial-relay'           => ShippingProviders\MondialRelayShippingProvider::class,
	'mpl'                     => ShippingProviders\MPLShippingProvider::class,
	'mrw'                     => ShippingProviders\MRWShippingProvider::class,
	'new-zealand-post'        => ShippingProviders\NewZealandPostShippingProvider::class,
	'nova-poshta'             => ShippingProviders\NovaPoshtaShippingProvider::class,
	'omniva'                  => ShippingProviders\OmnivaShippingProvider::class,
	'osterreichische-post'    => ShippingProviders\OsterreichischePostShippingProvider::class,
	'parcelforce'             => ShippingProviders\ParcelForceShippingProvider::class,
	'poczta-polska'           => ShippingProviders\PocztaPolskaShippingProvider::class,
	'post-luxembourg'         => ShippingProviders\PostLuxembourgShippingProvider::class,
	'posta-moldovei'          => ShippingProviders\PostaMoldoveiShippingProvider::class,
	'posta-romana'            => ShippingProviders\PostaRomanaShippingProvider::class,
	'poste-italiane'          => ShippingProviders\PosteItalianeShippingProvider::class,
	'poste-san-marino'        => ShippingProviders\PosteSanMarinoShippingProvider::class,
	'posten-norge-bring'      => ShippingProviders\PostenNorgeBringShippingProvider::class,
	'postnl'                  => ShippingProviders\PostNLShippingProvider::class,
	'postnord'                => ShippingProviders\PostNordShippingProvider::class,
	'purolator'               => ShippingProviders\PurolatorShippingProvider::class,
	'royal-mail'              => ShippingProviders\RoyalMailShippingProvider::class,
	'russian-post'            => ShippingProviders\RussianPostShippingProvider::class,
	'sda'                     => ShippingProviders\SDAShippingProvider::class,
	'seur'                    => ShippingProviders\SeurShippingProvider::class,
	'slovenska-posta'         => ShippingProviders\SlovenskaPostaShippingProvider::class,
	'spee-dee-delivery'       => ShippingProviders\SpeeDeeDeliveryShippingProvider::class,
	'startrack'               => ShippingProviders\StarTrackShippingProvider::class,
	'swiss-post'              => ShippingProviders\SwissPostShippingProvider::class,
	'toll'                    => ShippingProviders\TollShippingProvider::class,
	'ukrposhta'               => ShippingProviders\UkrposhtaShippingProvider::class,
	'ups'                     => ShippingProviders\UPSShippingProvider::class,
	'usps'                    => ShippingProviders\USPSShippingProvider::class,
	'urgent-cargus'           => ShippingProviders\UrgentCargusShippingProvider::class,
	'yurtici-kargo'           => ShippingProviders\YurticiKargoShippingProvider::class,
	'zasilkovna'              => ShippingProviders\ZasilkovnaShippingProvider::class,
);
